/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import jclass.table3.JCAdjustable;
import jclass.table3.JDKSupport;
import jclass.table3.Table;
import jclass.util.JCImageCreator;
import jclass.util.JCVector;

public class DefaultScrollbar
extends Canvas
implements JCAdjustable,
Runnable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int min;
    int max;
    int dir;
    protected int slider;
    transient Image image;
    JCVector listeners = new JCVector();
    int line = 21;
    int page = 200;
    int arrow_pressed;
    long filter_time;
    long last_time;
    private static final int MIN_SLIDERSIZE = 10;
    private static final int MIN_BTNSIZE = 3;
    private static final int MAX_BTNSIZE = 16;
    int btnPress;
    private int btnSize = 16;
    private int barSize;
    private int sliderStart;
    private int sliderSize;
    private int major;
    private int minor;
    private static final Color BRIGHTER = new Color(200, 200, 200);
    private static final Color DARKER = new Color(140, 140, 140);
    private int dragStart = -999;
    private int dragValueStart = -999;
    private Event mouse;
    private boolean repeatScroll = true;
    Rectangle trough_rect = new Rectangle();
    Rectangle btn_rect = new Rectangle();
    private final String[] arrow_down_pixels = new String[]{"       ", "bbbbbbb", " bbbbb ", "  bbb  ", "   b   "};
    private transient Image arrow_down_image;
    private final String[] arrow_up_pixels = new String[]{"   b   ", "  bbb  ", " bbbbb ", "bbbbbbb"};
    private transient Image arrow_up_image;
    private final String[] arrow_left_pixels = new String[]{"   b", "  bb", " bbb", "bbbb", " bbb", "  bb", "   b"};
    private transient Image arrow_left_image;
    private final String[] arrow_right_pixels = new String[]{"    ", "b   ", "bb  ", "bbb ", "bbbb", "bbb ", "bb  ", "b   "};
    private transient Image arrow_right_image;
    private transient JCImageCreator creator;
    private boolean new_fg = true;

    public DefaultScrollbar(int n) {
        this.dir = n;
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public int getOrientation() {
        return this.dir;
    }

    public synchronized int getValue() {
        return this.value;
    }

    protected int check(int n) {
        return Math.min(Math.max(this.min, n), this.max - this.slider);
    }

    public synchronized void setValue(int n) {
        if ((n = this.check(n)) != this.value) {
            this.value = n;
            this.repaint();
        }
    }

    public void setValue(int n, boolean bl) {
        if ((n = this.check(n)) == this.value) {
            return;
        }
        this.value = n;
        this.drawTroughAndSlider();
        if (!bl) {
            return;
        }
        Event event = this.mouse;
        if (this.btnPress == 0 || event == null) {
            event = new Event(this, 605, new Integer(n));
            event.when = System.currentTimeMillis();
        }
        this.scroll(event, this.getValue());
    }

    public void scroll(Event event, int n) {
        int n2 = 5;
        switch (event.id) {
            case 602: {
                n2 = 1;
                break;
            }
            case 601: {
                n2 = 2;
                break;
            }
            case 604: {
                n2 = 4;
                break;
            }
            case 603: {
                n2 = 3;
                break;
            }
        }
        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, n2, n);
        int n3 = 0;
        while (n3 < this.listeners.size()) {
            ((AdjustmentListener)this.listeners.elementAt(n3)).adjustmentValueChanged(adjustmentEvent);
            ++n3;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getVisibleAmount() {
        return this.slider;
    }

    public void setUnitIncrement(int n) {
        this.line = n;
    }

    public int getUnitIncrement() {
        return this.line;
    }

    public void setBlockIncrement(int n) {
        this.page = n;
    }

    public int getBlockIncrement() {
        return this.page;
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            n4 = n3;
        }
        this.page = this.slider = n2;
        this.min = n3;
        this.max = n4;
        this.value = n;
        if (this.getPeer() != null) {
            int n5 = this.barSize;
            int n6 = this.sliderSize;
            int n7 = this.sliderStart;
            this.setSliderSize();
            if (n5 != this.barSize || n6 != this.sliderSize || n7 != this.sliderStart) {
                this.repaint();
            }
        }
    }

    public synchronized void setMinimum(int n) {
        this.setValues(this.value, this.slider, n, this.max);
    }

    public synchronized void setMaximum(int n) {
        this.setValues(this.value, this.slider, this.min, n);
    }

    public synchronized void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.min, this.max);
    }

    public boolean atEnd() {
        return this.value == 0 || this.value >= this.max - this.slider;
    }

    public boolean dragging() {
        return this.dragStart != -999;
    }

    public void setFilterTime(long l) {
        this.filter_time = l;
    }

    public boolean isRepeatScroll() {
        return this.repeatScroll;
    }

    public void setRepeatScroll(boolean bl) {
        this.repeatScroll = bl;
    }

    protected int preferredWidth() {
        if (this.dir == 1) {
            return 16;
        }
        return 100;
    }

    protected int preferredHeight() {
        if (this.dir == 0) {
            return 16;
        }
        return 100;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.dragging()) {
            int n3 = this.value;
            this.value = -999;
            this.setValue(n3, true);
        }
        this.btnPress = 0;
        this.mouse = null;
        this.dragValueStart = -999;
        this.dragStart = -999;
        this.paint(this.getGraphics());
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.getParent() instanceof Table) {
            Table table = (Table)this.getParent();
            if (table.resize_column != -999 || table.resize_row != -999) {
                return true;
            }
        }
        if (this.sliderSize == this.barSize) {
            return true;
        }
        if (event.when - this.last_time < 20L) {
            return true;
        }
        this.last_time = event.when;
        if (this.btnPress != 0) {
            return true;
        }
        int n3 = this.dir == 0 ? n : n2;
        int n4 = this.btnSize;
        if (n3 < 0) {
            return true;
        }
        if (n3 > this.btnSize * 2 + this.barSize) {
            return true;
        }
        if (n3 > n4 + this.sliderStart && n3 < n4 + this.sliderStart + this.sliderSize) {
            return true;
        }
        if (event.controlDown()) {
            if (n3 < n4 + this.sliderStart + this.sliderSize / 2) {
                this.setValue(this.min, true);
            } else {
                this.setValue(this.max - this.slider, true);
            }
            return true;
        }
        this.arrow_pressed = 0;
        if (n3 < n4) {
            this.btnPress = this.arrow_pressed = -this.line;
            event.id = 601;
        } else if (n3 < n4 + this.sliderStart) {
            this.btnPress = -this.page;
            event.id = 603;
        } else if (n3 < n4 + this.barSize) {
            this.btnPress = this.page;
            event.id = 604;
        } else {
            this.btnPress = this.arrow_pressed = this.line;
            event.id = 602;
        }
        this.mouse = event;
        this.setValue(this.value + this.btnPress, true);
        if (this.arrow_pressed != 0 && this.repeatScroll) {
            new Thread(this).start();
        }
        this.paint(this.getGraphics());
        return true;
    }

    public void run() {
        int n = 250;
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(n);
            }
            catch (Throwable throwable) {}
            if (this.btnPress == 0) {
                Thread.currentThread().stop();
                this.repaint();
                return;
            }
            this.setValue(this.value + this.btnPress, true);
            n = 50;
        }
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3;
        if (this.getParent() instanceof Table) {
            Table table = (Table)this.getParent();
            if (table.resize_column != -999 || table.resize_row != -999) {
                return true;
            }
        }
        if (this.sliderSize == this.barSize) {
            return true;
        }
        if (this.btnPress != 0) {
            return true;
        }
        int n4 = n3 = this.dir == 0 ? event.x : event.y;
        if (this.dragStart == -999) {
            this.dragStart = n3;
            this.dragValueStart = this.value;
        } else {
            boolean bl;
            boolean bl2 = bl = event.when - this.last_time >= this.filter_time;
            if (bl) {
                this.last_time = event.when;
            }
            int n5 = this.toValue(n3 - this.dragStart);
            this.setValue(this.dragValueStart + n5, bl);
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (this.sliderSize == this.barSize) {
            return true;
        }
        if (n == 1002) {
            event.id = 603;
            this.setValue(this.value - this.page, true);
            return true;
        }
        if (n == 1003) {
            event.id = 604;
            this.setValue(this.value + this.page, true);
            return true;
        }
        if (n == 1000) {
            this.setValue(this.min, true);
            return true;
        }
        if (n == 1001) {
            this.setValue(this.max - this.slider, true);
            return true;
        }
        return super.keyDown(event, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.major = this.dir == 0 ? n3 : n4;
        this.minor = this.dir == 0 ? n4 : n3;
        super.setBounds(n, n2, n3, n4);
    }

    void drawTroughAndSlider() {
        if (this.getPeer() == null) {
            return;
        }
        if (this.dir == 0) {
            JDKSupport.setBounds(this.trough_rect, this.btnSize, 1, this.major - 2 * this.btnSize, this.minor - 2);
        } else {
            JDKSupport.setBounds(this.trough_rect, 1, this.btnSize, this.minor - 2, this.major - 2 * this.btnSize);
        }
        Graphics graphics = this.image.getGraphics();
        graphics.clipRect(this.trough_rect.x, this.trough_rect.y, this.trough_rect.width, this.trough_rect.height);
        this.paintComponent(graphics);
        graphics.dispose();
        graphics = this.getGraphics();
        graphics.clipRect(this.trough_rect.x, this.trough_rect.y, this.trough_rect.width, this.trough_rect.height);
        graphics.drawImage(this.image, 0, 0, null);
        graphics.dispose();
    }

    void setSliderSize() {
        this.barSize = Math.max(10, this.major - 32);
        this.sliderSize = this.min >= this.max ? this.barSize : Math.min(this.barSize, Math.max(this.toPixels(this.slider), 8));
        this.sliderStart = Math.max(0, Math.min(this.toPixels(this.value - this.min), this.barSize - this.sliderSize - 1));
    }

    private void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color;
        Color color2 = graphics.getColor();
        Color color3 = color2.equals(Color.white) ? BRIGHTER : color2.brighter();
        Color color4 = color = color2.equals(Color.white) ? DARKER : color2.darker();
        if (!bl) {
            graphics.setColor(color);
        }
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(bl ? color3 : color);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.setColor(bl ? color : color3);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
        graphics.setColor(color2);
    }

    private void fill3DEdgeRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        this.fill3DRect(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, bl);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    protected void drawSlider(Graphics graphics) {
        graphics.setColor(this.getBackground());
        if (this.dir == 0) {
            this.fill3DEdgeRect(graphics, this.sliderStart + this.btnSize, 0, this.sliderSize + 1, this.minor, true);
            graphics.setColor(Color.black);
            graphics.drawLine(this.btnSize, 0, this.btnSize + this.major - 1, 0);
            graphics.drawRect(this.btnSize, this.minor - 1, this.btnSize + this.major - 1, this.minor - 1);
            return;
        }
        this.fill3DEdgeRect(graphics, 0, this.sliderStart + this.btnSize, this.minor, this.sliderSize + 1, true);
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.btnSize, 0, this.major - 1);
        graphics.drawRect(this.minor - 1, this.btnSize, this.minor - 1, this.major - 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.size().height == 0 || this.size().width == 0) {
            return;
        }
        if (this.image == null || this.image.getHeight(null) < this.size().height || this.image.getWidth(null) < this.size().width) {
            this.image = this.createImage(this.size().width, this.size().height);
        }
        Graphics graphics2 = this.image.getGraphics();
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle != null) {
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintComponent(graphics2);
        graphics.drawImage(this.image, 0, 0, null);
        graphics2.dispose();
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        this.setSliderSize();
        graphics.setColor(this.getBackground().equals(Color.white) ? BRIGHTER : this.getBackground().brighter());
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        graphics.setColor(this.getBackground());
        if (this.btnPress == 0) {
            this.arrow_pressed = 0;
        }
        if ((rectangle = graphics.getClipRect()) == null) {
            rectangle = new Rectangle(this.size());
        }
        if (this.dir == 0) {
            JDKSupport.setBounds(this.btn_rect, 0, 0, this.btnSize, this.minor);
            if (this.btn_rect.intersects(rectangle)) {
                this.fill3DEdgeRect(graphics, 0, 0, this.btnSize, this.minor, this.arrow_pressed > -this.line);
                this.drawImage(graphics, this.arrow_left_pixels, this.arrow_left_image, 5, 4);
            }
            JDKSupport.setBounds(this.btn_rect, this.major - this.btnSize, 0, this.btnSize, this.minor);
            if (this.btn_rect.intersects(rectangle)) {
                this.fill3DEdgeRect(graphics, this.major - this.btnSize, 0, this.btnSize, this.minor, this.arrow_pressed < this.line);
                this.drawImage(graphics, this.arrow_right_pixels, this.arrow_right_image, this.major - this.btnSize + 6, 3);
            }
            this.drawSlider(graphics);
            return;
        }
        if (this.dir == 1) {
            JDKSupport.setBounds(this.btn_rect, 0, 0, this.minor, this.btnSize);
            if (this.btn_rect.intersects(rectangle)) {
                this.fill3DEdgeRect(graphics, 0, 0, this.minor, this.btnSize, this.arrow_pressed > -this.line);
                this.drawImage(graphics, this.arrow_up_pixels, this.arrow_up_image, 4, 6);
            }
            JDKSupport.setBounds(this.btn_rect, 0, this.major - this.btnSize, this.minor, this.btnSize);
            if (this.btn_rect.intersects(rectangle)) {
                this.fill3DEdgeRect(graphics, 0, this.major - this.btnSize, this.minor, this.btnSize, this.arrow_pressed < this.line);
                this.drawImage(graphics, this.arrow_down_pixels, this.arrow_down_image, 4, this.major - this.btnSize + 5);
            }
            this.drawSlider(graphics);
        }
    }

    protected int toPixels(int n) {
        if (this.max == this.min) {
            return 0;
        }
        int n2 = (int)((long)this.barSize * (long)n / (long)(this.max - this.min));
        return Math.max(n2, 0);
    }

    protected int toValue(int n) {
        if (this.barSize == 0) {
            return 0;
        }
        return (int)((long)n * (long)(this.max - this.min) / (long)this.barSize);
    }

    public void setForeground(Color color) {
        this.new_fg = color != this.getForeground();
        super.setForeground(color);
        this.repaint();
    }

    private Image createImage(String[] stringArray, Image image) {
        if (!this.new_fg && image != null) {
            return image;
        }
        if (this.creator == null) {
            this.creator = new JCImageCreator(this);
        }
        this.creator.setColor('b', this.getForeground().darker());
        this.new_fg = false;
        this.creator.setSize(stringArray[0].length(), stringArray.length);
        return this.creator.create(stringArray);
    }

    private void drawImage(Graphics graphics, String[] stringArray, Image image, int n, int n2) {
        image = this.createImage(stringArray, image);
        graphics.drawImage(image, n, n2, null);
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",val=" + this.value + ",vis=" + this.getVisibleAmount() + ",min=" + this.min + ",max=" + this.max + (this.dir == 1 ? ",vert" : ",horz");
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (!this.listeners.contains(adjustmentListener)) {
            this.listeners.addElement(adjustmentListener);
        }
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners.removeElement(adjustmentListener);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        switch (event.id) {
            case 501: {
                this.mouseDown(event, event.x, event.y);
                break;
            }
            case 502: {
                this.mouseUp(event, event.x, event.y);
                break;
            }
            case 504: {
                this.mouseEnter(event, event.x, event.y);
                break;
            }
            case 505: {
                this.mouseExit(event, event.x, event.y);
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        switch (event.id) {
            case 503: {
                this.mouseMove(event, event.x, event.y);
                break;
            }
            case 506: {
                this.mouseDrag(event, event.x, event.y);
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    void dispose() {
        if (this.creator != null) {
            this.creator = null;
        }
    }
}

